/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.natives;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.createtweaker.CreateTweaker;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Arrays;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/createtweaker/recipe/ProcessingRecipeBuilder")
@NativeTypeRegistration(value=ProcessingRecipeBuilder.class, zenCodeName="mods.createtweaker.ProcessingRecipeBuilder")
public class ExpandProcessingRecipeBuilder {
    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> withItemIngredients(ProcessingRecipeBuilder internal, IIngredient ... ingredients) {
        return internal.withItemIngredients((Ingredient[])Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new));
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> withSingleItemOutput(ProcessingRecipeBuilder internal, IItemStack output) {
        return internal.withSingleItemOutput(output.getInternal());
    }

    @SafeVarargs
    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> withItemOutputs(ProcessingRecipeBuilder internal, Percentaged<IItemStack> ... outputs) {
        return internal.withItemOutputs((ProcessingOutput[])Arrays.stream(outputs).map(stack -> new ProcessingOutput(((IItemStack)stack.getData()).getInternal(), (float)stack.getPercentage())).toArray(ProcessingOutput[]::new));
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> withFluidIngredients(ProcessingRecipeBuilder internal, CTFluidIngredient ... ingredients) {
        FluidIngredient[] fluidIngredients = (FluidIngredient[])Arrays.stream(ingredients).map(CreateTweaker::mapFluidIngredients).toArray(FluidIngredient[]::new);
        return internal.withFluidIngredients(fluidIngredients);
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> withFluidOutputs(ProcessingRecipeBuilder internal, MCFluidStack ... outputs) {
        return internal.withFluidOutputs((FluidStack[])Arrays.stream(outputs).map(MCFluidStack::getInternal).toArray(FluidStack[]::new));
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> duration(ProcessingRecipeBuilder internal, int ticks) {
        return internal.duration(ticks);
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> averageProcessingDuration(ProcessingRecipeBuilder internal) {
        return internal.averageProcessingDuration();
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> requiresHeat(ProcessingRecipeBuilder internal, HeatCondition condition) {
        return internal.requiresHeat(condition);
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> require(ProcessingRecipeBuilder internal, IIngredient ingredient) {
        return internal.require(ingredient.asVanillaIngredient());
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> require(ProcessingRecipeBuilder internal, CTFluidIngredient ingredient) {
        return internal.require(CreateTweaker.mapFluidIngredients(ingredient));
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> output(ProcessingRecipeBuilder internal, Percentaged<IItemStack> item) {
        return internal.output((float)item.getPercentage(), ((IItemStack)item.getData()).getInternal());
    }

    @ZenCodeType.Method
    public static ProcessingRecipeBuilder<ProcessingRecipe<Container>> output(ProcessingRecipeBuilder internal, MCFluidStack fluidStack) {
        return internal.output(fluidStack.getInternal());
    }
}

